/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.EnumMap;
import java.util.Map;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.NamedBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class CustomizableBlockEntity
extends NamedBlockEntity
implements IModuleInventory,
ICustomizable {
    private NonNullList<ItemStack> modules = NonNullList.func_191197_a((int)this.getMaxNumberOfModules(), (Object)ItemStack.field_190927_a);
    private Map<ModuleType, Boolean> moduleStates = new EnumMap<ModuleType, Boolean>(ModuleType.class);

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.modules = this.readModuleInventory(tag);
        this.moduleStates = this.readModuleStates(tag);
        this.readOptions(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.writeModuleInventory(tag);
        this.writeModuleStates(tag);
        this.writeOptions(tag);
        return tag;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public boolean isModuleEnabled(ModuleType module) {
        return this.hasModule(module) && this.moduleStates.get((Object)module) == Boolean.TRUE;
    }

    @Override
    public void toggleModuleState(ModuleType module, boolean shouldBeEnabled) {
        this.moduleStates.put(module, shouldBeEnabled);
        if (shouldBeEnabled) {
            this.onModuleInserted(this.getModule(module), module, true);
        } else {
            this.onModuleRemoved(this.getModule(module), module, true);
        }
    }

    @Override
    public World myLevel() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos myPos() {
        return this.field_174879_c;
    }
}

